/*
 * Copyright (C) 2012 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer
 *    in the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of Google Inc. nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef RTCSessionDescription_h
#define RTCSessionDescription_h

#include "bindings/core/v8/ScriptWrappable.h"
#include "public/platform/WebRTCSessionDescription.h"
#include "wtf/Forward.h"

namespace blink {

class Dictionary;
class ExceptionState;

class RTCSessionDescription FINAL : public GarbageCollectedFinalized<RTCSessionDescription>, public ScriptWrappable {
    DEFINE_WRAPPERTYPEINFO();
public:
    static RTCSessionDescription* create(const Dictionary&, ExceptionState&);
    static RTCSessionDescription* create(WebRTCSessionDescription);

    String type();
    void setType(const String&, ExceptionState&);

    String sdp();
    void setSdp(const String&);

    WebRTCSessionDescription webSessionDescription();

    void trace(Visitor*) { }

private:
    explicit RTCSessionDescription(WebRTCSessionDescription);

    WebRTCSessionDescription m_webSessionDescription;
};

} // namespace blink

#endif // RTCSessionDescription_h
